import { useApplicationWorkflow } from "@/hooks/use-application-workflow"
import { ComponentWithClassName } from "@/types/utils"
import { Dialog, DialogContent, DialogDescription, DialogHeader, DialogTitle } from "./ui/dialog"
import { cn } from "@/lib/utils"
import LoadingCircle from "./icons/loading.circle"

export function LoadingDialog({
  className
}: ComponentWithClassName) {
  const {
    resetWorkflow,
    workflow,
  } = useApplicationWorkflow()

  if (!workflow) {
    return null;
  }

  return (
    <Dialog open defaultOpen onOpenChange={resetWorkflow}>
      <DialogHeader>
        <DialogTitle className="sr-only">Loading content for modal.</DialogTitle>
        <DialogDescription className="sr-only">Currently loading content for modal.</DialogDescription>
      </DialogHeader>
      <DialogContent className={cn("grid place-content-center min-h-64", className)}>
        <LoadingCircle />
      </DialogContent>
    </Dialog>
  )
}

